# GODD

## Environment

Install the required packages from `requirements.txt`. A simplified version of the requirements can be found [here](https://github.com/ehoogeboom/e3_diffusion_for_molecules/blob/main/requirements.txt).

**Note**: If you want to set up a rdkit environment, it may be easiest to install conda and run:
``conda create -c conda-forge -n my-rdkit-env rdkit`` and then install the other required packages. But the code should still run without rdkit installed though.

## Split QM9
```sh sh/split_qm.sh```

## Train

### For Scaffold
```sh sh/train_gadm_scaffold.sh```

### For Ring
```sh sh/train_gadm_ring.sh```

**results** Trained Models are saved in ./Models


## Evaluate

### For Scaffold
e.g., ClassIII:
```python eval_analyze.py --model_path ./Models/qm9_scaffold_outputs/da_qm9_scaffold_masked --n_samples 10_000 --save_to_xyz True --target_domain ClassIII --dataset qm9_scaffold_ClassIII```

### For Ring
e.g., generate 8 rings:
```python eval_analyze.py --model_path ./Models/qm9_ring_outputs/da_qm9_ring_masked --n_samples 10_000 --save_to_xyz True --target_domain 8 --dataset qm9_ring_n_8```